/*
	File: briefing.sqf
	Author: Loyalguard

	Description:
	Briefing file for the CEG Demo Mission,

	Parameters:
	None.
 
	Execution:
	Executed from init.sqf.
*/

player createDiaryRecord ["Diary", ["Chernarus Electrical Grid", "<br/>DESCRIPTION<br/>
===========<br/><br/>
The Chernarus Electrical Grid (CEG) simulates an electrical power grid throughout all of the South Zagoria Region of Chernarus. There are two power plants, Elektrozavodsk and Chernogorsk. Power plant smokestacks emit smoke when generating electricity. There are seven substations with one or more transformer arrays (buses). Transformers emit a humming noise when energized Street lights are turned off when power is cutoff.<br/><br/>
DEMO<br/>
====<br/><br/>
In this demo you can click anywhere on the map to teleport to that location.  You are also armed with three satchel charges to destroy transformers.  There is one playable position available at each substation.  Inside the shack at each power plant location there is a computer to logon to the grid control system (demo mission only).  See the Tasks section for a demo task.<br/><br/>
IN-GAME USE<br/>
===========<br/><br/>
There are three ways players can interact with the grids:<br/><br/>
1. Destroy components to cut off power. A transformer object must be completely destroyed for power flowing through it to be cut off. The same principle goes for powerplant buildings. An object is completely destroyed when it disappears (or is replaced with rubble/ruins).<br/><br/>
2. Players can also manually cutoff and restore power at by tripping and closing circuit breakers respectively. To cut off power, walk towards the transformers and face the center. When close enough, you will see an action menu option to ""Trip Circuit Breaker"" or ""Close Circuit Breaker"". This option can be turned off by the mission maker.  Mission makers can also add the possibility of an arc flash explosion when manually switching breakers.<br/><br/>
3. If given the option by the mission maker, players can logon to the grid control system and monitor and control power remotely. Players can also access a close circuit television system to monitor substation activity.  The grid control system has a point and click interface. If a circuit breaker is tripped or closed as described above, it can be changed back again via the control system (and vise versa).  A password (set by the mission maker) may be required to access the grid control system.  In the demo mission no password is required at Chernogorsk, but a password is required at Elektrozavodsk.  The password is abc123<br/><br/>
4. Portions of the grid are redundant in case certain components are offline.<br/><br/>
5. There are components on the map that are inactive because they are not connected to the grid. For example the transformer in Solnichniy at Grid 132/90 and the northernmost transformer in the Berezino substation. These were not included in the simulation because the transmission lines connecting them to other nodes are not intact. Additionally, none of the transmission towers (pylons), transmission lines, or small power poles are monitored for damage because there are far too many to reasonably track.<br/><br/>
6. For additional guidance a visual guide is available for download with detailed images and diagrams documenting different grid features."]]; 



